/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.global;

import java.awt.Color;
import java.util.HashMap;
import java.util.Vector;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import noppes.npcs.CustomNpcs;
import noppes.npcs.client.Client;
import noppes.npcs.client.gui.GuiNpcMobSpawnerSelector;
import noppes.npcs.client.gui.SubGuiNpcBiomes;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNPCInterface2;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcCheckBox;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcSlider;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IGuiNpcSlider;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.IScrollData;
import noppes.npcs.client.gui.util.ISliderListener;
import noppes.npcs.client.gui.util.ISubGuiListener;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.controllers.data.SpawnData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.ValueUtil;

public class GuiNpcNaturalSpawns
extends GuiNPCInterface2
implements IGuiData,
IScrollData,
ITextfieldListener,
ICustomScrollListener,
ISliderListener,
ISubGuiListener,
GuiYesNoCallback {
    protected final HashMap<String, Integer> data = new HashMap();
    protected GuiCustomScroll scroll;
    protected SpawnData spawn = new SpawnData();
    protected Entity displayNpc = null;
    protected int maxSize;
    protected boolean accept = false;

    public GuiNpcNaturalSpawns(EntityNPCInterface npc) {
        super(npc);
        Client.sendData(EnumPacketServer.NaturalSpawnGetAll, new Object[0]);
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 1: {
                if (!this.accept) {
                    GuiYesNo guiyesno = new GuiYesNo((GuiYesNoCallback)this, new TextComponentTranslation("gui.acceptMessage", new Object[0]).func_150254_d(), new TextComponentTranslation("spawning.accept.message", new Object[0]).func_150254_d(), 0);
                    this.displayGuiScreen((GuiScreen)guiyesno);
                    return;
                }
                this.save();
                String name = new TextComponentTranslation("gui.new", new Object[0]).func_150254_d();
                while (this.data.containsKey(name)) {
                    name = name + "_";
                }
                SpawnData spawn = new SpawnData();
                spawn.name = name;
                Client.sendData(EnumPacketServer.NaturalSpawnSave, spawn.writeNBT(new NBTTagCompound()));
                break;
            }
            case 2: {
                if (!this.data.containsKey(this.scroll.getSelected())) {
                    return;
                }
                Client.sendData(EnumPacketServer.NaturalSpawnRemove, this.spawn.id);
                this.spawn = new SpawnData();
                this.scroll.clear();
                this.displayNpc = null;
                break;
            }
            case 3: {
                this.setSubGui(new SubGuiNpcBiomes(this.spawn));
                break;
            }
            case 4: {
                this.spawn.liquid = button.getValue() == 0;
                button.setHoverText("spawning.hover.liquid." + button.getValue(), new Object[0]);
                break;
            }
            case 5: {
                this.setSubGui(new GuiNpcMobSpawnerSelector());
                break;
            }
            case 6: {
                this.spawn.canSeeSummon = ((GuiNpcCheckBox)button).isSelected();
                break;
            }
            case 25: {
                this.spawn.compoundEntity = new NBTTagCompound();
                this.displayNpc = null;
                this.func_73866_w_();
                break;
            }
            case 27: {
                this.spawn.type = button.getValue();
            }
        }
    }

    public void func_73878_a(boolean result, int id) {
        this.displayGuiScreen(this);
        if (!result) {
            return;
        }
        this.accept = true;
        this.buttonEvent(this.getButton(1));
    }

    @Override
    public void subGuiClosed(SubGuiInterface gui) {
        GuiNpcMobSpawnerSelector selector;
        NBTTagCompound compound;
        if (gui instanceof GuiNpcMobSpawnerSelector && (compound = (selector = (GuiNpcMobSpawnerSelector)gui).getCompound()) != null) {
            this.spawn.compoundEntity = compound;
            if (compound.func_150297_b("SpawnCycle", 3)) {
                compound.func_74768_a("SpawnCycle", 4);
            }
        }
        this.func_73866_w_();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.subgui == null) {
            int x = 387;
            int y = 196;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
            Gui.func_73734_a((int)(this.guiLeft + x - 30), (int)(this.guiTop + y - 77), (int)(this.guiLeft + x + 31), (int)(this.guiTop + y + 9), (int)-8355712);
            Gui.func_73734_a((int)(this.guiLeft + x - 29), (int)(this.guiTop + y - 76), (int)(this.guiLeft + x + 30), (int)(this.guiTop + y + 8), (int)-16777216);
            GlStateManager.func_179121_F();
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.subgui == null) {
            int p = 0;
            int x = 387;
            int y = 196;
            if (this.displayNpc != null) {
                int r;
                this.displayNpc.field_70173_aa = this.player.field_70173_aa;
                if (this.displayNpc instanceof EntityLivingBase) {
                    r = (int)(3L * this.player.field_70170_p.func_82737_E() % 360L);
                } else {
                    r = 0;
                    y -= 34;
                    if (this.displayNpc instanceof EntityItem) {
                        p = 30;
                        y += 10;
                    }
                    if (this.displayNpc instanceof EntityItemFrame) {
                        x += 16;
                    }
                }
                GlStateManager.func_179094_E();
                this.drawNpc(this.displayNpc, x, y, 1.0f, r, p, 0);
                GlStateManager.func_179121_F();
            }
        }
    }

    private String getTitle(NBTTagCompound compound) {
        this.displayNpc = EntityList.func_75615_a((NBTTagCompound)compound, (World)this.field_146297_k.field_71441_e);
        if (this.displayNpc != null) {
            return this.displayNpc.func_70005_c_();
        }
        return "gui.selectnpc";
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 0);
            this.scroll.setSize(143, 208);
        }
        this.scroll.guiLeft = this.guiLeft + 214;
        this.scroll.guiTop = this.guiTop + 4;
        this.addScroll(this.scroll);
        GuiNpcButton button = new GuiNpcButton(1, this.guiLeft + 358, this.guiTop + 38, 58, 20, "gui.add");
        button.setHoverText("spawning.hover.add", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(2, this.guiLeft + 358, this.guiTop + 61, 58, 20, "gui.remove");
        button.setHoverText("spawning.hover.del", new Object[0]);
        this.addButton(button);
        if (this.spawn.id < 0) {
            return;
        }
        Entity entity = null;
        try {
            entity = EntityList.func_75615_a((NBTTagCompound)this.spawn.compoundEntity, (World)this.field_146297_k.field_71441_e);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.maxSize = 50;
        if (entity instanceof EntityNPCInterface) {
            this.maxSize = 70;
        } else if (entity instanceof EntityAnimal) {
            this.maxSize = 10;
        } else if (entity instanceof EntityMob) {
            this.maxSize = 70;
        }
        int lId = 0;
        int x = this.guiLeft + 5;
        int y = this.guiTop + 5;
        this.addLabel(new GuiNpcLabel(lId++, "gui.title", x, y + 3));
        GuiNpcTextField textField = new GuiNpcTextField(1, this, this.field_146289_q, x + 56, y, 150, 14, this.spawn.name);
        textField.setHoverText("spawning.hover.name", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(lId++, "spawning.biomes", x, (y += 17) + 3));
        button = new GuiNpcButton(3, x + 56, y, 74, 16, "selectServer.edit");
        if (this.spawn.biomes.isEmpty()) {
            button.layerColor = new Color(-1040352).getRGB();
        }
        button.setHoverText("spawning.hover.biomes", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lId++, "gui.type", x, (y += 18) + 3));
        button = new GuiNpcButton(27, x + 56, y, 74, 16, new String[]{"spawner.any", "spawner.dark", "spawner.light"}, this.spawn.type);
        button.setHoverText("spawning.hover.type", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(4, x + 132, y, 74, 16, new String[]{"spawning.liquid.0", "spawning.liquid.1"}, this.spawn.liquid ? 0 : 1);
        button.setHoverText("spawning.hover.liquid." + button.getValue(), new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(5, x, y += 18, 184, 16, this.getTitle(this.spawn.compoundEntity));
        button.setHoverText("spawning.hover.sel.npc", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(25, x + 186, y, 20, 16, "X");
        button.setHoverText("spawning.hover.del.npc", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lId++, new TextComponentTranslation("spawning.weightedChance", new Object[0]).func_150254_d() + ":", x, (y += 29) - 10));
        GuiNpcSlider slider = new GuiNpcSlider(this, 2, x, y, 160, 12, (float)this.spawn.field_76292_a / 100.0f);
        slider.setHoverText(new TextComponentTranslation("spawning.hover.chance", new Object[0]).func_150254_d(), new Object[0]);
        this.addSlider(slider);
        textField = new GuiNpcTextField(2, this, this.field_146289_q, x + 163, y, 43, 12, "" + this.spawn.field_76292_a);
        textField.setMinMaxDefault(1L, 100L, this.spawn.field_76292_a);
        textField.setHoverText("spawning.hover.chance", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(lId++, "spawning.group", x, (y += 25) - 10));
        slider = new GuiNpcSlider(this, 3, x, y, 160, 12, (float)this.spawn.group / 8.0f);
        slider.setHoverText(new TextComponentTranslation("spawning.hover.chance", new Object[0]).func_150254_d(), new Object[0]);
        this.addSlider(slider);
        textField = new GuiNpcTextField(3, this, this.field_146289_q, x + 163, y, 43, 12, "" + this.spawn.group);
        textField.setMinMaxDefault(1L, 8L, this.spawn.group);
        textField.setHoverText("spawning.hover.group", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(lId, "spawning.range", x, (y += 25) - 10));
        slider = new GuiNpcSlider(this, 4, x, y, 160, 12, (float)this.spawn.range / 16.0f);
        slider.setHoverText(new TextComponentTranslation("spawning.hover.chance", new Object[0]).func_150254_d(), new Object[0]);
        this.addSlider(slider);
        textField = new GuiNpcTextField(4, this, this.field_146289_q, x + 163, y, 43, 12, "" + this.spawn.range);
        textField.setMinMaxDefault(1L, 16L, this.spawn.range);
        textField.setHoverText("spawning.hover.range", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(lId, "spawning.maximum.in", x, (y += 25) - 10));
        slider = new GuiNpcSlider(this, 5, x, y, 160, 12, (float)this.spawn.maxNearPlayer / (float)this.maxSize);
        slider.setHoverText(new TextComponentTranslation("spawning.hover.maximum.in", new Object[]{TextFormatting.GOLD + "" + this.maxSize}).func_150254_d(), new Object[0]);
        this.addSlider(slider);
        textField = new GuiNpcTextField(5, this, this.field_146289_q, x + 163, y, 43, 12, "" + this.spawn.maxNearPlayer);
        textField.setMinMaxDefault(1L, this.maxSize, this.spawn.maxNearPlayer);
        textField.setHoverText("spawning.hover.maximum.in", TextFormatting.GOLD + "" + this.maxSize);
        this.addTextField(textField);
        button = new GuiNpcCheckBox(6, x, y + 14, 184, 14, "spawning.can.see", "spawning.not.see", this.spawn.canSeeSummon);
        button.setHoverText("spawning.hover.can.see", new Object[0]);
        this.addButton(button);
    }

    @Override
    public void func_73869_a(char c, int i) {
        if (i == 1 && this.subgui == null) {
            this.save();
            CustomNpcs.proxy.openGui(this.npc, EnumGuiType.MainMenuGlobal);
            return;
        }
        super.func_73869_a(c, i);
    }

    @Override
    public void mouseDragged(IGuiNpcSlider guiNpcSlider) {
        String value;
        int id = guiNpcSlider.getID();
        switch (id) {
            case 2: {
                this.spawn.field_76292_a = ValueUtil.correctInt((int)(guiNpcSlider.getSliderValue() * 100.0f), 1, 100);
                value = "" + this.spawn.field_76292_a;
                guiNpcSlider.setDisplayString(value + "%");
                break;
            }
            case 3: {
                this.spawn.group = ValueUtil.correctInt((int)(guiNpcSlider.getSliderValue() * 8.0f), 1, 8);
                value = "" + this.spawn.group;
                guiNpcSlider.setDisplayString(value);
                break;
            }
            case 4: {
                this.spawn.range = ValueUtil.correctInt((int)(guiNpcSlider.getSliderValue() * 16.0f), 1, 16);
                value = "" + this.spawn.range;
                guiNpcSlider.setDisplayString(value);
                break;
            }
            case 5: {
                this.spawn.maxNearPlayer = ValueUtil.correctInt((int)(guiNpcSlider.getSliderValue() * (float)this.maxSize), 1, this.maxSize);
                value = "" + this.spawn.maxNearPlayer;
                guiNpcSlider.setDisplayString(value);
                break;
            }
            default: {
                return;
            }
        }
        if (this.getTextField(id) != null) {
            this.getTextField(id).setFullText(value);
        }
    }

    @Override
    public void mousePressed(IGuiNpcSlider guiNpcSlider) {
    }

    @Override
    public void mouseReleased(IGuiNpcSlider guiNpcSlider) {
        this.spawn.field_76292_a = (int)(guiNpcSlider.getSliderValue() * 100.0f);
    }

    @Override
    public void save() {
        GuiNpcTextField.unfocus();
        if (this.spawn.id >= 0) {
            Client.sendData(EnumPacketServer.NaturalSpawnSave, this.spawn.writeNBT(new NBTTagCompound()));
        }
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        if (scroll.getID() == 0) {
            this.save();
            String selected = this.scroll.getSelected();
            this.spawn = new SpawnData();
            Client.sendData(EnumPacketServer.NaturalSpawnGet, this.data.get(selected));
        }
    }

    @Override
    public void scrollDoubleClicked(String selection, IGuiCustomScroll scroll) {
    }

    @Override
    public void setData(Vector<String> list, HashMap<String, Integer> data) {
        String name = this.scroll.getSelected();
        this.data.clear();
        this.data.putAll(data);
        this.scroll.setList(list);
        if (name != null) {
            this.scroll.setSelected(name);
        }
        this.func_73866_w_();
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        this.spawn.readNBT(compound);
        this.setSelected(this.spawn.name);
        this.func_73866_w_();
    }

    @Override
    public void setSelected(String selected) {
    }

    @Override
    public void unFocused(IGuiNpcTextField textField) {
        switch (textField.getID()) {
            case 1: {
                String name = textField.getFullText();
                if (name.isEmpty() || this.data.containsKey(name)) {
                    textField.setFullText(this.spawn.name);
                    break;
                }
                String old = this.spawn.name;
                this.data.remove(old);
                this.spawn.name = name;
                this.data.put(this.spawn.name, this.spawn.id);
                this.scroll.replace(old, this.spawn.name);
                break;
            }
            case 2: {
                this.spawn.field_76292_a = textField.getInteger();
                if (this.getSlider(4) == null) break;
                this.getSlider(4).setDisplayString(new TextComponentTranslation("spawning.weightedChance", new Object[0]).func_150254_d() + ": " + this.spawn.field_76292_a);
                break;
            }
            case 3: {
                this.spawn.group = textField.getInteger();
                break;
            }
            case 4: {
                this.spawn.range = textField.getInteger();
                break;
            }
            case 5: {
                this.spawn.maxNearPlayer = textField.getInteger();
            }
        }
    }
}

